'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

'Variablen zur Anzeige am Bildschirm
Public Pos_Links As Double              'Blattkanten
Public Pos_Blatt1_Oben As Double
Public Pos_Blatt2_Oben As Double
Public Pos_A4_Breite As Double
Public Pos_A4_Hoehe As Double

Public Sub Rote_Bereiche_Anzeigen()
    'Vorbereitungen
    Me.Blatt1_Bereichsanzeige.Visible = False
    Me.Blatt2_Bereichsanzeige.Visible = False
    Me.Blatt1_Bereichsanzeige.Height = 0
    Me.Blatt1_Bereichsanzeige.Width = 0
    Me.Blatt2_Bereichsanzeige.Height = 0
    Me.Blatt2_Bereichsanzeige.Width = 0
    'Bereichsanzeige einstellen
    If Blatt1_Rot_Sichtbar = True Then
        Me.Blatt1_Bereichsanzeige.Left = Blatt1_Rot_Links
        Me.Blatt1_Bereichsanzeige.Top = Blatt1_Rot_Oben
        Me.Blatt1_Bereichsanzeige.Width = Blatt1_Rot_Breite
        Me.Blatt1_Bereichsanzeige.Height = Blatt1_Rot_Hoehe
        Me.Blatt1_Bereichsanzeige.Visible = True
    End If
    If Blatt2_Rot_Sichtbar = True Then
        Me.Blatt2_Bereichsanzeige.Left = Blatt2_Rot_Links
        Me.Blatt2_Bereichsanzeige.Top = Blatt2_Rot_Oben
        Me.Blatt2_Bereichsanzeige.Width = Blatt2_Rot_Breite
        Me.Blatt2_Bereichsanzeige.Height = Blatt2_Rot_Hoehe
        Me.Blatt2_Bereichsanzeige.Visible = True
    End If
End Sub

Public Sub Fuellen_Auswahl_Formularbereich()
    'HF_Blatt
    Me.Auswahl_Formularbereich.RowSource = """" & Formularbereich_HF_Blatt.Kuerzel & """" & ";"
    Me.Auswahl_Formularbereich.RowSource = Me.Auswahl_Formularbereich.RowSource & """" & Formularbereich_HF_Blatt.Bezeichnung & """" & ";"
    If Formularbereich_HF_Blatt.Deaktiviert = True Then
        Me.Auswahl_Formularbereich.RowSource = Me.Auswahl_Formularbereich.RowSource & """deaktivert""" & ";"
    Else
        Me.Auswahl_Formularbereich.RowSource = Me.Auswahl_Formularbereich.RowSource & ";"
    End If
    'HF_BK
    Me.Auswahl_Formularbereich.RowSource = Me.Auswahl_Formularbereich.RowSource & """" & Formularbereich_HF_BK.Kuerzel & """" & ";"
    Me.Auswahl_Formularbereich.RowSource = Me.Auswahl_Formularbereich.RowSource & """" & Formularbereich_HF_BK.Bezeichnung & """" & ";"
    If Formularbereich_HF_BK.Deaktiviert = True Then
        Me.Auswahl_Formularbereich.RowSource = Me.Auswahl_Formularbereich.RowSource & """deaktivert""" & ";"
    Else
        Me.Auswahl_Formularbereich.RowSource = Me.Auswahl_Formularbereich.RowSource & ";"
    End If
    
    'weitere Formularbereiche...
    
    
End Sub

Public Sub Auswahl_Format_AfterUpdate()
    'Rote Markierung entfernen
    Me.Blatt1_Bereichsanzeige.Visible = False
    Me.Blatt2_Bereichsanzeige.Visible = False
    
    If Me.Auswahl_Format.Value = 1 Then         'Hochformat
        'Pfeil fr ausgewhlte Elemente
        Me.ElementMarker.Visible = False
        Me.ElementMarker.Left = 0.998 * Twips_Faktor
        'Blattkanten fr Bildschirmanzeige
        Pos_Links = 1.4 * Twips_Faktor
        Pos_Blatt1_Oben = 0.3 * Twips_Faktor
        Pos_Blatt2_Oben = 6.4 * Twips_Faktor
        'Weier Hintergrund
        Me.Blatt1.Top = Pos_Blatt1_Oben
        Me.Blatt1.Left = Pos_Links
        Me.Blatt1.Height = Pos_A4_Hoehe
        Me.Blatt1.Width = Pos_A4_Breite
        Me.Blatt2.Top = Pos_Blatt2_Oben
        Me.Blatt2.Left = Pos_Links
        Me.Blatt2.Height = Pos_A4_Hoehe
        Me.Blatt2.Width = Pos_A4_Breite
        'Seitenrnder
        Me.Blatt1_Rand_Links.Top = Pos_Blatt1_Oben
        Me.Blatt1_Rand_Links.Left = Pos_Links
        Me.Blatt1_Rand_Links.Height = Pos_A4_Hoehe
        Me.Blatt1_Rand_Links.Width = HF_Blatt_Links / 5 * Twips_Faktor
        Me.Blatt1_Rand_Rechts.Top = Pos_Blatt1_Oben
        Me.Blatt1_Rand_Rechts.Left = (Pos_Links + Pos_A4_Breite) - (HF_Blatt_Rechts / 5 * Twips_Faktor)
        Me.Blatt1_Rand_Rechts.Height = Pos_A4_Hoehe
        Me.Blatt1_Rand_Rechts.Width = HF_Blatt_Rechts / 5 * Twips_Faktor
        Me.Blatt1_Rand_Oben.Top = Pos_Blatt1_Oben
        Me.Blatt1_Rand_Oben.Left = Pos_Links
        Me.Blatt1_Rand_Oben.Height = HF_Blatt_Oben / 5 * Twips_Faktor
        Me.Blatt1_Rand_Oben.Width = Pos_A4_Breite
        Me.Blatt1_Rand_Unten.Top = (Pos_Blatt1_Oben + Pos_A4_Hoehe) - (HF_Blatt_Unten / 5 * Twips_Faktor)
        Me.Blatt1_Rand_Unten.Left = Pos_Links
        Me.Blatt1_Rand_Unten.Height = HF_Blatt_Unten / 5 * Twips_Faktor
        Me.Blatt1_Rand_Unten.Width = Pos_A4_Breite
        Me.Blatt2_Rand_Links.Top = Pos_Blatt2_Oben
        Me.Blatt2_Rand_Links.Left = Pos_Links
        Me.Blatt2_Rand_Links.Height = Pos_A4_Hoehe
        Me.Blatt2_Rand_Links.Width = HF_Blatt_Links / 5 * Twips_Faktor
        Me.Blatt2_Rand_Rechts.Top = Pos_Blatt2_Oben
        Me.Blatt2_Rand_Rechts.Left = (Pos_Links + Pos_A4_Breite) - (HF_Blatt_Rechts / 5 * Twips_Faktor)
        Me.Blatt2_Rand_Rechts.Height = Pos_A4_Hoehe
        Me.Blatt2_Rand_Rechts.Width = HF_Blatt_Rechts / 5 * Twips_Faktor
        Me.Blatt2_Rand_Oben.Top = Pos_Blatt2_Oben
        Me.Blatt2_Rand_Oben.Left = Pos_Links
        Me.Blatt2_Rand_Oben.Height = HF_Blatt_Oben / 5 * Twips_Faktor
        Me.Blatt2_Rand_Oben.Width = Pos_A4_Breite
        Me.Blatt2_Rand_Unten.Top = (Pos_Blatt2_Oben + Pos_A4_Hoehe) - (HF_Blatt_Unten / 5 * Twips_Faktor)
        Me.Blatt2_Rand_Unten.Left = Pos_Links
        Me.Blatt2_Rand_Unten.Height = HF_Blatt_Unten / 5 * Twips_Faktor
        Me.Blatt2_Rand_Unten.Width = Pos_A4_Breite
        'graue Blattumrandung
        Me.Blatt1_Rahmen.Top = Pos_Blatt1_Oben
        Me.Blatt1_Rahmen.Left = Pos_Links
        Me.Blatt1_Rahmen.Height = Pos_A4_Hoehe
        Me.Blatt1_Rahmen.Width = Pos_A4_Breite
        Me.Blatt2_Rahmen.Top = Pos_Blatt2_Oben
        Me.Blatt2_Rahmen.Left = Pos_Links
        Me.Blatt2_Rahmen.Height = Pos_A4_Hoehe
        Me.Blatt2_Rahmen.Width = Pos_A4_Breite
    End If
    If Me.Auswahl_Format.Value = 2 Then         'Querformat
        'Pfeil fr ausgewhlte Elemente
        Me.ElementMarker.Visible = False
        Me.ElementMarker.Left = 0.199 * Twips_Faktor
        'Blattkanten fr Bildschirmanzeige
        Pos_Links = 0.6 * Twips_Faktor
        Pos_Blatt1_Oben = 2 * Twips_Faktor
        Pos_Blatt2_Oben = 6.4 * Twips_Faktor
        'Weier Hintergrund
        Me.Blatt1.Top = Pos_Blatt1_Oben
        Me.Blatt1.Left = Pos_Links
        Me.Blatt1.Height = Pos_A4_Breite
        Me.Blatt1.Width = Pos_A4_Hoehe
        Me.Blatt2.Top = Pos_Blatt2_Oben
        Me.Blatt2.Left = Pos_Links
        Me.Blatt2.Height = Pos_A4_Breite
        Me.Blatt2.Width = Pos_A4_Hoehe
        'Seitenrnder
        Me.Blatt1_Rand_Links.Top = Pos_Blatt1_Oben
        Me.Blatt1_Rand_Links.Left = Pos_Links
        Me.Blatt1_Rand_Links.Height = Pos_A4_Breite
        Me.Blatt1_Rand_Links.Width = HF_Blatt_Links / 5 * Twips_Faktor
        Me.Blatt1_Rand_Rechts.Top = Pos_Blatt1_Oben
        Me.Blatt1_Rand_Rechts.Left = (Pos_Links + Pos_A4_Hoehe) - (HF_Blatt_Rechts / 5 * Twips_Faktor)
        Me.Blatt1_Rand_Rechts.Height = Pos_A4_Breite
        Me.Blatt1_Rand_Rechts.Width = HF_Blatt_Rechts / 5 * Twips_Faktor
        Me.Blatt1_Rand_Oben.Top = Pos_Blatt1_Oben
        Me.Blatt1_Rand_Oben.Left = Pos_Links
        Me.Blatt1_Rand_Oben.Height = HF_Blatt_Oben / 5 * Twips_Faktor
        Me.Blatt1_Rand_Oben.Width = Pos_A4_Hoehe
        Me.Blatt1_Rand_Unten.Top = (Pos_Blatt1_Oben + Pos_A4_Breite) - (HF_Blatt_Unten / 5 * Twips_Faktor)
        Me.Blatt1_Rand_Unten.Left = Pos_Links
        Me.Blatt1_Rand_Unten.Height = HF_Blatt_Unten / 5 * Twips_Faktor
        Me.Blatt1_Rand_Unten.Width = Pos_A4_Hoehe
        Me.Blatt2_Rand_Links.Top = Pos_Blatt2_Oben
        Me.Blatt2_Rand_Links.Left = Pos_Links
        Me.Blatt2_Rand_Links.Height = Pos_A4_Breite
        Me.Blatt2_Rand_Links.Width = HF_Blatt_Links / 5 * Twips_Faktor
        Me.Blatt2_Rand_Rechts.Top = Pos_Blatt2_Oben
        Me.Blatt2_Rand_Rechts.Left = (Pos_Links + Pos_A4_Hoehe) - (HF_Blatt_Rechts / 5 * Twips_Faktor)
        Me.Blatt2_Rand_Rechts.Height = Pos_A4_Breite
        Me.Blatt2_Rand_Rechts.Width = HF_Blatt_Rechts / 5 * Twips_Faktor
        Me.Blatt2_Rand_Oben.Top = Pos_Blatt2_Oben
        Me.Blatt2_Rand_Oben.Left = Pos_Links
        Me.Blatt2_Rand_Oben.Height = HF_Blatt_Oben / 5 * Twips_Faktor
        Me.Blatt2_Rand_Oben.Width = Pos_A4_Hoehe
        Me.Blatt2_Rand_Unten.Top = (Pos_Blatt2_Oben + Pos_A4_Breite) - (HF_Blatt_Unten / 5 * Twips_Faktor)
        Me.Blatt2_Rand_Unten.Left = Pos_Links
        Me.Blatt2_Rand_Unten.Height = HF_Blatt_Unten / 5 * Twips_Faktor
        Me.Blatt2_Rand_Unten.Width = Pos_A4_Hoehe
        'graue Blattumrandung
        Me.Blatt1_Rahmen.Top = Pos_Blatt1_Oben
        Me.Blatt1_Rahmen.Left = Pos_Links
        Me.Blatt1_Rahmen.Height = Pos_A4_Breite
        Me.Blatt1_Rahmen.Width = Pos_A4_Hoehe
        Me.Blatt2_Rahmen.Top = Pos_Blatt2_Oben
        Me.Blatt2_Rahmen.Left = Pos_Links
        Me.Blatt2_Rahmen.Height = Pos_A4_Breite
        Me.Blatt2_Rahmen.Width = Pos_A4_Hoehe
    End If
    
    'Anzeige der Berichtselemente
    If HF_BK_Name1.Sichtbar = True And Formularbereich_HF_BK.Deaktiviert = False Then
        'Elementeigenschaften setzen
        Me.HF_BK_Name1_Anzeige.Top = Me.Blatt1.Top + ((HF_Blatt_Oben + HF_BK_Name1.Oben) / 5 * Twips_Faktor)
        Me.HF_BK_Name1_Anzeige.Left = Me.Blatt1.Left + ((HF_Blatt_Links + HF_BK_Name1.Links) / 5 * Twips_Faktor)
        Me.HF_BK_Name1_Anzeige.Height = HF_BK_Name1.Hoehe / 5 * Twips_Faktor
        Me.HF_BK_Name1_Anzeige.Width = HF_BK_Name1.Breite / 5 * Twips_Faktor
        Me.HF_BK_Name1_Anzeige.Visible = True
    Else
        Me.HF_BK_Name1_Anzeige.Visible = False
    End If
    '...
    
    
End Sub

Private Sub Auswahl_Formularbereich_AfterUpdate()
    Me.Blatt1_Bereichsanzeige.Visible = False
    Me.Blatt2_Bereichsanzeige.Visible = False
    Me.Einstellungen_5_UF.SourceObject = "Einstellungen_5_" & Me.Auswahl_Formularbereich.Value
End Sub

Private Sub Befehl93_Click()
    DoCmd.Close
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Kunden", acSaveYes
    DoCmd.Close acForm, "Rechnungen_Uebersicht", acSaveYes
        
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
    'Zoomfaktor am Bildschirm (cm -> Twips)
    Twips_Faktor = 570
    
    'Standardseitenrnder (A4-Hochformat)
    HF_Blatt_Oben = 1.5
    HF_Blatt_Unten = 1.5
    HF_Blatt_Links = 2
    HF_Blatt_Rechts = 0.8
    
    'Werte fr Bereich HF_KB
    HF_BK_Hoehe = 9.898
    
    'Blattkanten fr Bildschirmanzeige
    Pos_Links = 1.4 * Twips_Faktor
    Pos_Blatt1_Oben = 0.3 * Twips_Faktor
    Pos_Blatt2_Oben = 6.4 * Twips_Faktor
    'Hhe und Breite sind 1/5 der Originalgre
    Pos_A4_Breite = 4.2 * Twips_Faktor
    Pos_A4_Hoehe = 5.94 * Twips_Faktor
    
    'rote Bereichsanzeige initialisieren
    Blatt1_Rot_Sichtbar = False
    Blatt1_Rot_Links = 0
    Blatt1_Rot_Oben = 0
    Blatt1_Rot_Breite = 0
    Blatt1_Rot_Hoehe = 0
    Blatt2_Rot_Sichtbar = False
    Blatt2_Rot_Links = 0
    Blatt2_Rot_Oben = 0
    Blatt2_Rot_Breite = 0
    Blatt2_Rot_Hoehe = 0
    'und anzeigen/ausblenden
    Rote_Bereiche_Anzeigen

    'Formularauswahl initialisieren
    Formularbereich_HF_Blatt.Kuerzel = "HF_Blatt"
    Formularbereich_HF_Blatt.Bezeichnung = "Seiteneinstellung"
    Formularbereich_HF_Blatt.Deaktiviert = False
    Formularbereich_HF_BK.Kuerzel = "HF_BK"
    Formularbereich_HF_BK.Bezeichnung = "Kopfbereich Seite 1"
    Formularbereich_HF_BK.Deaktiviert = False
    'Formularauswahl Steuerelement fllen
    Fuellen_Auswahl_Formularbereich
    
    'Variablen mit (aktuelle) Werte fllen
    HF_BK_Name1.Sichtbar = True
    HF_BK_Name1.Text = "Schriftmuster"
    HF_BK_Name1.Notiz = "Dies ist der Name1 der Firmenstammdaten."
    HF_BK_Name1.Oben = 0
    HF_BK_Name1.Links = 0
    HF_BK_Name1.Hoehe = 0.582
    HF_BK_Name1.Breite = 12.921
    HF_BK_Name1.Vergroesserbar = False
    HF_BK_Name1.FarbeVordergrund = 0
    HF_BK_Name1.FarbeHintergrund = 0
    HF_BK_Name1.Schriftart = "Arial"
    HF_BK_Name1.SchriftGroesse = 14
    HF_BK_Name1.SchriftFarbe = 0
    HF_BK_Name1.SchriftFett = False
    HF_BK_Name1.SchriftKursiv = False
    HF_BK_Name1.SchriftDurchgestrichen = False
    HF_BK_Name1.SchriftUnterstrichen = False
    HF_BK_Name1.SchriftAusrichtung = "links"
    HF_BK_Name1.RahmenArt = 0
    HF_BK_Name1.RahmenDicke = 0
    HF_BK_Name1.RahmenFarbe = 0
    
    'Formularansicht initialisieren
    Auswahl_Format_AfterUpdate
    
End Sub

Private Sub ZuEinstellungen1_Click()
On Error GoTo Err_ZuEinstellungen1_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Einstellungen"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_5", acSaveYes
    

Exit_ZuEinstellungen1_Click:
    Exit Sub

Err_ZuEinstellungen1_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen1_Click
    
End Sub

Private Sub ZuEinstellungen2_Click()
On Error GoTo Err_ZuEinstellungen2_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Einstellungen_2"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_5", acSaveYes
    

Exit_ZuEinstellungen2_Click:
    Exit Sub

Err_ZuEinstellungen2_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen2_Click
    
End Sub

Private Sub ZuEinstellungen3_Click()
On Error GoTo Err_ZuEinstellungen3_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Einstellungen_3"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_5", acSaveYes
    

Exit_ZuEinstellungen3_Click:
    Exit Sub

Err_ZuEinstellungen3_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen3_Click
    
End Sub

Private Sub ZuEinstullungen4_Click()
On Error GoTo Err_ZuEinstellungen4_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Einstellungen_4"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_5", acSaveYes
    

Exit_ZuEinstellungen4_Click:
    Exit Sub

Err_ZuEinstellungen4_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen4_Click
    
End Sub
Private Sub VorschauFormular_Click()
On Error GoTo Err_VorschauFormular_Click

    Dim stDocName As String

    stDocName = "Datenbankzuordnungen"
    DoCmd.OpenReport stDocName, acPreview

Exit_VorschauFormular_Click:
    Exit Sub

Err_VorschauFormular_Click:
    MsgBox err.Description
    Resume Exit_VorschauFormular_Click
    
End Sub
